<?php
/*
Theme Name: Qoxag
Theme URI: https://themeforest.net/user/tripples/portfolio
Author: Tripples
Author URI: https://themewinter.com
Description: Qoxag - News Magazine WordPress Theme..
Version: 2.1.1
License: GNU General Public License v2 or later
License URI: LICENSE
Text Domain: qoxag
Tags: theme-options, post-formats, featured-images
*/


// shorthand contants
// ------------------------------------------------------------------------
define('QOXAG_THEME', 'Qoxag WordPress Theme');
define('QOXAG_VERSION', '2.1.1');


// shorthand contants for theme assets url
// ------------------------------------------------------------------------
define('QOXAG_THEME_URI', get_template_directory_uri());
define('QOXAG_IMG', QOXAG_THEME_URI . '/assets/images');
define('QOXAG_CSS', QOXAG_THEME_URI . '/assets/css');
define('QOXAG_JS', QOXAG_THEME_URI . '/assets/js');


// shorthand contants for theme assets directory path
// ----------------------------------------------------------------------------------------
define('QOXAG_THEME_DIR', get_template_directory());
define('QOXAG_IMG_DIR', QOXAG_THEME_DIR . '/assets/images');
define('QOXAG_CSS_DIR', QOXAG_THEME_DIR . '/assets/css');
define('QOXAG_JS_DIR', QOXAG_THEME_DIR . '/assets/js');

define('QOXAG_CORE', QOXAG_THEME_DIR . '/core');
define('QOXAG_REMOTE_CONTENT', esc_url('https://demo-themewinter.com/demo-content/qoxag'));
define('QOXAG_LIVE_URL', esc_url('https://demo-themewinter.com/qoxag/'));


// set up the content width value based on the theme's design
// ----------------------------------------------------------------------------------------
if (!isset($content_width)) {
    $content_width = 800;
}

// set up theme default and register various supported features.
// ----------------------------------------------------------------------------------------

function qoxag_setup()
{

    // make the theme available for translation
    $lang_dir = QOXAG_THEME_DIR . '/languages';
    load_theme_textdomain('qoxag', $lang_dir);

    // add support for post formats
    add_theme_support('post-formats', [
        'standard',
        'image',
        'video',
        'audio',
        'gallery',
        'quote'
    ]);

    // add support for automatic feed links
    add_theme_support('automatic-feed-links');

    // let WordPress manage the document title
    add_theme_support('title-tag');

    // add support for post thumbnails
    add_theme_support('post-thumbnails');

    // add support for custom logo
    add_theme_support('custom-logo');

    // hard crop center center
    set_post_thumbnail_size(850, 560, ['center', 'center']);
    add_image_size('qoxag-medium', 350,  230, ['center', 'center']);
    add_image_size('qoxag-small', 136, 86, ['center', 'center']);

    // woocommerce support
    add_theme_support('woocommerce', array(
        'thumbnail_image_width' => 600,
        'gallery_thumbnail_image_width' => 300,
        'single_image_width' => 600,
    ));

    // register navigation menus
    register_nav_menus(
        [
            'primary' => esc_html__('Primary Menu', 'qoxag')
        ]
    );

    // HTML5 markup support for search form, comment form, and comments
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption'
    ));
    add_theme_support('align-wide');
    add_theme_support('editor-styles');
    add_theme_support('wp-block-styles');
}
add_action('after_setup_theme', 'qoxag_setup');

function qoxag_remove_devm_settings()
{
    remove_submenu_page('themes.php', 'devm-settings');
}
add_action('admin_menu', 'qoxag_remove_devm_settings', 999);


// include the init.php
// ----------------------------------------------------------------------------------------
require_once(QOXAG_CORE . '/init.php');
require_once(QOXAG_CORE . '/elementor/elementor.php');

// license 
require_once(QOXAG_CORE . '/libs/theme-license-manager/theme-license-manager.php');
$store_url = "https://themewinter.com/";
$product_id = 65516;
\Theme\License\Theme_License_Manager::instance()->run($store_url, $product_id);

// wordpress default image size remove
// ----------------------------------------------------------------------------------------
add_filter('intermediate_image_sizes_advanced', 'qoxag_remove_default_images');
function qoxag_remove_default_images($sizes)
{
    unset($sizes['small']);
    unset($sizes['medium']);
    unset($sizes['large']);
    unset($sizes['medium_large']);
    return $sizes;
}

// for optimization dequeue styles
add_action('wp_enqueue_scripts', 'qoxag_remove_unused_css_files', 100);
function qoxag_remove_unused_css_files()
{
    $fontawesome = qoxag_option('optimization_fontawesome_enable', 'yes');
    $blocklibrary = qoxag_option('optimization_blocklibrary_enable', 'yes');
    $elementoricons = qoxag_option('optimization_elementoricons_enable', 'yes');
    $elementkitsicons = qoxag_option('optimization_elementkitsicons_enable', 'yes');
    $socialicons = qoxag_option('optimization_socialicons_enable', 'yes');
    $dashicons = qoxag_option('optimization_dashicons_enable', 'yes');

    // dequeue wp-review styles file
    wp_dequeue_style('wur_content_css');
    wp_deregister_style('wur_content_css');

    if ($fontawesome == 'no') {
        wp_dequeue_style('font-awesome');
        wp_deregister_style('font-awesome');
        wp_dequeue_style('font-awesome-5-all');
        wp_deregister_style('font-awesome-5-all');
        wp_dequeue_style('font-awesome-4-shim');
        wp_deregister_style('font-awesome-4-shim');
        wp_dequeue_style('fontawesome-five-css');
    }

    if ($blocklibrary == 'no') {
        wp_dequeue_style('wp-block-library');
        wp_dequeue_style('wp-block-library-theme');
        wp_dequeue_style('wc-block-style');
        wp_dequeue_style('wc-block-style');
    }

    if ($elementkitsicons == 'no') {
        wp_dequeue_style('elementor-icons-ekiticons');
        wp_deregister_style('elementor-icons-ekiticons');
        wp_dequeue_style('ekit-widget-styles');
        wp_dequeue_style('ekit-responsive');
    }

    if ($socialicons == 'no') {
        wp_dequeue_style('xs_login_font_login_css');
    }

    if ($elementoricons == 'no') {
        // Don't remove it in the backend
        if (is_admin() || current_user_can('manage_options')) {
            return;
        }
        wp_dequeue_style('elementor-animations');
        wp_dequeue_style('elementor-icons');
        wp_deregister_style('elementor-icons');
    }

    if ($dashicons == 'no') {
        // Don't remove it in the backend
        if (is_admin() || current_user_can('manage_options')) {
            return;
        }
        wp_dequeue_style('dashicons');
    }
}

add_action('elementor/frontend/after_register_styles', function () {
    $fontawesome = qoxag_option('optimization_fontawesome_enable', 'yes');
    if ($fontawesome == 'no') {
        foreach (['solid', 'regular', 'brands'] as $style) {
            wp_deregister_style('elementor-icons-fa-' . $style);
        }
    }
}, 20);

add_filter('elementor/icons_manager/native', function ($icons) {
    $fontawesome = qoxag_option('optimization_fontawesome_enable', 'yes');
    if ($fontawesome == 'no') {
        unset($icons['fa-regular']);
        unset($icons['fa-solid']);
        unset($icons['fa-brands']);
    }

    return $icons;
});

add_action('elementskit_lite/after_loaded', function () {
    add_filter('elementor/icons_manager/additional_tabs', function ($icons) {
        $elementkitsicons = qoxag_option('optimization_elementkitsicons_enable', 'yes');

        if ($elementkitsicons == 'no') {
            unset($icons['ekiticons']);
        }

        return $icons;
    });
});

/* disable option for font awesome icons from elementor editor */
add_action('elementor/frontend/after_register_styles', function () {
    $fontawesome = qoxag_option('optimization_fontawesome_enable', 'yes');
    if ($fontawesome == 'no') {
        foreach (['solid', 'regular', 'brands'] as $style) {
            wp_deregister_style('elementor-icons-fa-' . $style);
        }
    }

    $elementkitsicons = qoxag_option('optimization_elementkitsicons_enable', 'yes');
    if ($elementkitsicons == 'no') {
        wp_deregister_script('animate-circle');
        wp_dequeue_script('animate-circle');
        wp_deregister_script('elementskit-elementor');
        wp_dequeue_script('elementskit-elementor');
        wp_dequeue_style('e-animations');
        wp_deregister_style('e-animations');
    }
}, 20);


// dark light mode
function qoxag_darklight_mode()
{
    $style_darklight_mode = qoxag_option('style_darklight_mode');
    if ($style_darklight_mode == 'yes') {
?>
        <div class="color_swicher change-mode">
            <div class="switch_container">
                <i class="xts-icon xts-sun"></i>
                <i class="xts-icon xts-moon"></i>
            </div>
        </div>

    <?php
    }
}
add_action('wp_body_open', 'qoxag_darklight_mode');


function qoxag_preloader_function()
{
    $preloader_show = qoxag_option('preloader_show');
    if ($preloader_show == 'yes') {

        $qoxag_preloader_logo_url = qoxag_option('preloader_logo');
        if (!empty($qoxag_preloader_logo_url)) {
            $qoxag_preloader_logo_url = wp_get_attachment_image_src($qoxag_preloader_logo_url, 'full');
            if ($qoxag_preloader_logo_url['0'] != '') {
                $qoxag_preloader_logo_url = $qoxag_preloader_logo_url['0'];
            }
        }
        $qoxag_preloader_logo_url = $qoxag_preloader_logo_url;

    ?>
        <div id="preloader">
            <?php if ($qoxag_preloader_logo_url != ''): ?>

                <div class="preloader-logo">
                    <img width="286" height="115" class="img-fluid" src="<?php echo esc_url($qoxag_preloader_logo_url); ?>" alt="<?php echo get_bloginfo('name') ?>">
                </div>
            <?php else: ?>
                <div class="spinner">
                    <div class="double-bounce1"></div>
                    <div class="double-bounce2"></div>
                </div>
            <?php endif; ?>
            <div class="preloader-cancel-btn-wraper">
                <span class="btn btn-primary preloader-cancel-btn">
                    <?php esc_html_e('Cancel Preloader', 'qoxag'); ?></span>
            </div>
        </div>
    <?php
    }
}
add_action('wp_body_open', 'qoxag_preloader_function');

/* Push google analytics code in head area */
function qoxag_google_analytics()
{
    $google_analytics_code = qoxag_option('google_analytics_code');
    if ($google_analytics_code != '') {
        echo do_shortcode($google_analytics_code);
    }
}
add_action('wp_head', 'qoxag_google_analytics', 1);


/* Push google analytics code in head area */
function qoxag_meta_des_viewport()
{
    $meta_viewport = qoxag_option('optimization_meta_viewport', 'yes');
    if ($meta_viewport == 'yes') {
    ?>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5">
        <meta name="description" content="<?php if (is_single()) {
                                                single_post_title('', true);
                                            } else {
                                                bloginfo('name');
                                                echo " - ";
                                                bloginfo('description');
                                            }
                                            ?>" />
<?php }
}
add_action('wp_head', 'qoxag_meta_des_viewport', 1);
